--> pralable
-- USE BD_Air_France;

-- CAST ( expression AS data_type [ ( length ) ] )

SELECT CAST('ABC' AS BINARY(3)) AS " BINARY(3)", CAST ('ABC' AS VARBINARY) AS "VARBINARY";

SELECT CAST(CAST(GETDATE() AS SMALLDATETIME) AS VARBINARY) AS "VARBINARY";

SELECT CAST(1546.4 AS CHAR(4)) AS "CHAR(4)";

SELECT CAST('193.57' AS DECIMAL(5,2)) AS " DECIMAL(5,2)";

SELECT CAST('20120325' AS DATE) AS "DATE", CAST('20120325' AS SMALLDATETIME) AS "SMALLDATETIME",
       CAST('20120325' AS DATETIME2) AS "DATETIME2", 
       CAST('20120325' AS DATETIMEOFFSET) AS "DATETIMEOFFSET";

SELECT CAST(SYSDATETIMEOFFSET() AS CHAR(34)) AS "SYSDATETIMEOFFSET()";

SELECT CAST(CAST(SYSDATETIME() AS DATE) AS VARCHAR);
SELECT CAST(CAST(SYSDATETIME() AS SMALLDATETIME) AS VARCHAR);
SELECT CAST(CAST(SYSDATETIME() AS DATETIME2) AS VARCHAR);

-- CONVERT ( data_type [ ( length ) ] , expression [ , style ] )

DECLARE @f FLOAT;
SET     @f = 193445.574 / PI();
SELECT CONVERT(VARCHAR,@f,0) AS "Rel style 0",
       CONVERT(VARCHAR,@f,1) AS "Rel style 1",
       CONVERT(VARCHAR,@f,2) AS "Rel style 2";

--
   
DECLARE @s SMALLMONEY;
SET     @s = 214748.3647;

SELECT CONVERT(VARCHAR,@s,0) AS "SMALLMONEY style 0",
       CONVERT(VARCHAR,@s,1) AS "SMALLMONEY style 1",
       CONVERT(VARCHAR,@s,2) AS "SMALLMONEY style 2";

--

SELECT CONVERT(VARCHAR,GETDATE(),0) AS "Par dfaut", 
       CONVERT(VARCHAR,GETDATE(), 113) AS "Europe";

SELECT CONVERT(VARCHAR,GETDATE(),3)  AS "French sans sicle" ,
       CONVERT(VARCHAR,GETDATE(),103) AS "French avec sicle";

SELECT  CONVERT(VARCHAR,GETDATE(), 112) AS "ISO",
      CONVERT(VARCHAR,GETDATE(), 126) AS "ISO8601";

-- CAST and CONVERT  

DECLARE @d1 CHAR(8), @t1 INT;
SET     @d1 = '20120425';
SET     @t1 = 114926;
SELECT CONVERT(VARCHAR, CAST(@d1 AS DATE), 113)
      + ' ' + SUBSTRING(CAST (@t1 AS CHAR(6)),1,2)
      + ':' + SUBSTRING(CAST (@t1 AS CHAR(6)),3,2)
      + ':' + SUBSTRING(CAST (@t1 AS CHAR(6)),5,2);

-- collation French_CI_AS par dfaut

CREATE TABLE T_conversions_cnv
(cnv_varchar_8 VARCHAR(8) PRIMARY KEY,
 cnv_date      SMALLDATETIME,
 cnv_int       INT,
 cnv_float     FLOAT,
 cnv_decimal   DECIMAL(6,2));

INSERT INTO T_conversions_cnv
(cnv_varchar_8,cnv_date,cnv_int,cnv_float,   cnv_decimal) VALUES
(12345678,     26889,   '12345','12.34567E20','12.34567');

SELECT  * FROM  T_conversions_cnv WHERE   cnv_varchar_8 = 12345678;
SELECT  * FROM  T_conversions_cnv WHERE   cnv_varchar_8 = '12345678';

CREATE TABLE T_collations_col
(col_French_BIN VARCHAR(8) COLLATE French_BIN);

INSERT INTO T_collations_col VALUES ('cur');

SELECT  CONCAT(cnv.cnv_varchar_8,col.col_French_BIN)
FROM    T_collations_col col, T_conversions_cnv cnv;

SELECT  CONCAT(CAST(cnv.cnv_decimal AS VARCHAR(8)) COLLATE French_BIN,col.col_French_BIN)
        AS "Concatnation"
FROM    T_collations_col col, T_conversions_cnv cnv;

DROP TABLE T_conversions_cnv;
GO

DROP TABLE T_Collations_col;
GO

-- PARSE TRY_CONVERT, TRY PARSE

SELECT PARSE('123,45' AS NUMERIC(8,2) using 'fr-FR') AS Decimal;
SELECT PARSE('27/09/2013' as DATE using 'fr-FR') AS Date_FR;
SELECT PARSE('Samedi 28 Septembre 2013' AS DATETIME2 USING 'fr-FR') AS Date_FR;


SELECT TRY_PARSE('10.1200' AS DECIMAL(6,4));
SELECT TRY_PARSE('100.1200' AS DECIMAL(6,4)) ;


SET LANGUAGE English;
SELECT TRY_PARSE('13/10/2014' AS datetime2)  AS Date_Ang,
       TRY_PARSE('13/10/2014' AS datetime2 USING 'fr-FR') AS Date_Fra;

SET DATEFORMAT ymd;
SELECT TRY_CONVERT(datetime2, '2014/12/30') AS Date_ymd;
